<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// DBSEO "ShowPost URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_ShowPost
{
	public static $format = 'ShowPost_ShowPost';
	public static $structure = 'showpost.php?p=%d&post_count=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['post_id'], $urlInfo['post_count']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['postid'] 	= intval($data['postid'] 		? $data['postid'] 		: (isset($data['p']) ? $data['p'] : 0));
		$data['post_count'] = intval($data['post_count'] 	? $data['post_count'] 	: $data['postcount']);

		if ($data['postid'] AND !$data['threadid'])
		{
			// We need to extract thread info from post info
			$postInfo = self::getInfo($data['postid']);
			$data['threadid'] = $postInfo['threadid'];
		}

		if ($data['threadid'])
		{
			// Get our thread info
			$threadInfo = DBSEO::getThreadInfo($data['threadid']);
		}

		if (!$threadInfo['threadid'])
		{
			// Forum didn't exist
			return '';
		}

		if (!$threadInfo['seotitle'] OR preg_match('#[-_\s](?:post|print)?\d+$#', $threadInfo['seotitle']))
		{
			// Only do this in certain cases
			$threadInfo['seotitle'] .= ($threadInfo['seotitle'] ? DBSEO::$config['dbtech_dbseo_rewrite_separator'] : '') . 'a';
		}

		// Handle userid and username
		$replace['%thread_id%'] 	= $threadInfo['threadid'];
		$replace['%thread_title%'] 	= $threadInfo['seotitle'];

		$data['forumid'] = intval($threadInfo['forumid']);
		if ($data['forumid'])
		{
			// Grab our forum cache
			$forumcache = DBSEO::$db->fetchForumCache();

			// Grab our forum info
			$forumInfo = DBSEO::$db->cache['forumcache'][$data['forumid']];
		}
		
		if (!$forumInfo['forumid'])
		{
			// Forum didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%forum_id%'] 		= $forumInfo['forumid'];
		$replace['%forum_title%'] 	= DBSEO::rewriteForumUrl($forumInfo);

		// Handle userid and username
		$replace['%post_id%'] 		= intval($data['postid']);
		$replace['%post_count%'] 	= intval($data['post_count']);

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}


	/**
	 * Gets any extra information needed
	 *
	 * @param mixed $postIds
	 * 
	 * @return array
	 */
	public static function getInfo($postIds, $force = false)
	{
		$postInfo = array();

		if (!is_array($postIds))
		{
			// Ensure this is an array
			$postIds = array($postIds);
		}

		if (!$force)
		{
			foreach ($postIds as $key => $postId)
			{
				if (($postInfo = DBSEO::$datastore->fetch('postinfo.' . $postId)) === false)
				{
					// We don't have this cached
					continue;
				}

				// We had this cached, cache it internally too
				DBSEO::$cache['post'][$postId] = $postInfo;
			}
		}

		$queryList = array();
		foreach ($postIds as $key => $postId)
		{
			if (!isset(DBSEO::$cache['post'][$postId]) OR $force)
			{
				// Ensure this is done
				$queryList[$key] = intval($postId);
			}
		}

		if (count($queryList))
		{
			$info = DBSEO::$db->generalQuery('
				SELECT *
				FROM $post
				WHERE postid IN (' . implode(',', $queryList) . ')
			', false);
			foreach ($info as $arr)
			{
				// Build the cache
				DBSEO::$datastore->build('postinfo.' . $arr['postid'], $arr);

				// Cache this info
				DBSEO::$cache['post'][$arr['postid']] = $arr;
			}
		}

		if (count($postIds) == 1)
		{
			// We have only one, return only one
			$postInfo = DBSEO::$cache['post'][$postIds[0]];
		}
		else
		{
			foreach ($postIds as $key => $postId)
			{
				// Create this array
				$postInfo[$postId] = DBSEO::$cache['post'][$postId];
			}
		}

		return $postInfo;
	}
}